local assets = {
    Asset("ANIM", "anim/ghost_orchid.zip"),
}

local prefabs = {
    "ghost_orchid",
}

-- 简化的放置函数
local function onplaced(inst, pt)
    inst.Transform:SetPosition(pt.x, 0, pt.z)
    local orchid = SpawnPrefab("ghost_orchid")
    if orchid then
        orchid.Transform:SetPosition(pt.x, 0, pt.z)
        orchid:PushEvent("on_planted")
        
        -- 播放种植音效
        orchid.SoundEmitter:PlaySound("dontstarve/wilson/plant_seeds")
        
    end
    inst:Remove()
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    inst.entity:AddSoundEmitter()

    inst.AnimState:SetBank("entity")
    inst.AnimState:SetBuild("ghost_orchid")
    inst.AnimState:PlayAnimation("ghost_orchid_idle")

    -- 标准的地面物品物理设置
    MakeInventoryPhysics(inst)

    -- 库存物品组件
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/ghost_orchid_seed.xml"
    inst.components.inventoryitem.imagename = "ghost_orchid_seed"

    inst:AddTag("deployable")
    inst:AddTag("ghost_orchid_seed")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    -- 部署组件
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = onplaced
    inst.components.deployable:SetDeployMode(DEPLOYMODE.PLANT)
    inst.components.deployable.restrictedtag = "ghost_orchid_planter"

    -- 检查函数
    inst.components.deployable.test = function(inst, pt, mouseover, deployer)
        return TheWorld.Map:CanDeployAtPoint(pt, inst)
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL

    -- 漂浮组件
    inst:AddComponent("floater")
    inst.components.floater:SetSize("small")
    inst.components.floater:SetVerticalOffset(0.1)

    -- 燃烧和传播
    MakeSmallBurnable(inst, TUNING.TINY_BURNTIME)
    MakeSmallPropagator(inst)

    return inst
end

return Prefab("ghost_orchid_seed", fn, assets, prefabs)